/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.inventories.InternalInventory;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.menu.implementations.SkyChestMenu;
import appeng.util.inv.AppEngInternalInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=LidBlockEntity.class)
public class SkyChestBlockEntity
extends AEBaseInvBlockEntity
implements ClientTickingBlockEntity,
LidBlockEntity {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 36);
    private final ChestLidController chestLidController = new ChestLidController();
    @Nullable
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            this.playSound(level, pos, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            this.playSound(level, pos, SoundEvents.f_11747_);
        }

        private void playSound(Level level, BlockPos pos, SoundEvent event) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_6263_(null, x, y, z, event, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int p_155364_, int x) {
            level.m_7696_(pos, state.m_60734_(), 1, x);
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof SkyChestMenu) {
                SkyChestMenu menu = (SkyChestMenu)abstractContainerMenu;
                return menu.getChest() == SkyChestBlockEntity.this;
            }
            return false;
        }
    };

    public SkyChestBlockEntity(BlockEntityType<? extends SkyChestBlockEntity> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public void clientTick() {
        this.chestLidController.m_155374_();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        if (data.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(data.m_128461_("LootTable"));
            this.lootTableSeed = data.m_128454_("LootTableSeed");
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        if (this.lootTable != null) {
            data.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                data.m_128356_("LootTableSeed", this.lootTableSeed);
            }
        }
    }

    public void unpackLootTable(@Nullable Player openingPlayer) {
        Level level;
        if (this.lootTable != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable loottable = serverLevel.m_142572_().m_129898_().m_79217_(this.lootTable);
            if (openingPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)openingPlayer;
                CriteriaTriggers.f_10563_.m_54597_(serverPlayer, this.lootTable);
            }
            this.lootTable = null;
            LootContext.Builder lootBuilder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_(this.lootTableSeed);
            if (openingPlayer != null) {
                lootBuilder.m_78963_(openingPlayer.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)openingPlayer);
            }
            loottable.m_79123_(this.inv.toContainer(), lootBuilder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        this.unpackLootTable(null);
        super.addAdditionalDrops(level, pos, drops);
    }

    @Override
    public InteractionResult disassembleWithWrench(Player player, Level level, BlockHitResult hitResult) {
        return InteractionResult.FAIL;
    }
}

